function   [type,laynr]=identify(FName)

name=FName(1:findstr('.',FName)-1);
ext= FName(end-2:end);

%% ==== ASC Files ==================
% Legal names {'kD', 'vc', 'd', 'nl', 'ibound', 'fct', 'hk', 'cnc', 'conc', 'ahn'}

if strcmp(upper(ext),'ASC')
    switch name(1)
        case 'k'
            laynr=str2double(name(end));
            type ='k';
        case 'v'
            laynr=str2double(name(end));
            type ='v';
        case 'd'
            laynr=str2double(name(end));
            type ='d';
        case 'n'
            laynr=str2double(name(8:9));
            type='n';
        case 'i'
            laynr=str2double(name(end));
            type='i';
        case 'f'
            laynr=NaN;
            type='f';
        case 'r'
            laynr=NaN;
            type='r';
        case 'h'
            laynr=NaN;
            type='h';
        case 'c'
            switch name(2)
                case 'n'
                    laynr=NaN;
                    type='c';
                case 'o'
                    laynr=str2double(name(end));
                    type='C';
                otherwise
                    error('Don''t know what to do with %s',ascFName);
            end
        case 'a'
            laynr=NaN;
            type='a';
        otherwise
            error('Don''t know wat to do with %s',ascFName);
    end
    return;
end
%% ===== SCD files =====================================

% Legal SCD name: drn_tot rivj rivw_mz  rivz_mz ghb rivw rivz wel_tot  

if strcmp(upper(ext),'SCD')

    laynr=NaN;

    switch name(1)
        case 'd'
            type='d';
        case 'g'
            type='g';
        case 'w'
            type='w';
        case 'r'
            if strcmp(FName(1:4),'rivj')
                type='r';
            else
                type='?';
            end
        otherwise
            error('Don''t know wat to do with %s',ascFName);
    end
    return;
end

error('Illegal extension ''%s'' in indentify.m\n',FName);

